import { DateTimeModel } from "../dateTimeModel/date-time.model";

export class CustomerSalesRestrictionFilter {
    salesRestrictionId: number;
    salesRestrictionCode: string;
    groupId: number;
    customerId: number;
    outletId: number;
    startDateModel: DateTimeModel;
    endDateModel: DateTimeModel;
    includeInactive: boolean;
    allowCheckUpperLimit: boolean;
    nonZeroOnly: boolean;
    constructor() {
       this.salesRestrictionId = -1;
       this.groupId = -1;
       this.customerId = -1;
       this.outletId = -1;
       this.includeInactive = false; 
       this.allowCheckUpperLimit = false;
       this.nonZeroOnly = false;
    }
}

export class CustomerSalesRestrictionModel {
    salesRestrictionId: number;
    salesRestrictionCode: string;
    // createdDate: Date
    createdBy: number;
    employeeName: String;
    periodically: number;
    inactive: number;
    customerId: number;
    outletId: number;
    groupId: number;
    startDateModel: DateTimeModel;
    endDateModel: DateTimeModel;
    isEdit: boolean;
    assignmentList: CustomerSalesRestrictionAssignmentModel[];
    detailList: CustomerSalesRestrictionDetail[];
    organizationIds: number[]
    constructor() {
        this.salesRestrictionId = -1;
        this.customerId = -1;
        this.outletId = -1; 
        this.inactive = 0;
        this.periodically = 0;
        this.groupId = -1;
        this.isEdit = false;
        this.assignmentList = [];
        this.detailList = [];
        this.organizationIds = [];
    }
}

export class CustomerSalesRestrictionAssignmentModel {
    salesRestrictionId: number;
    customerId: number;
    outletId: number;
    groupId: number;
    channelId: number;
    subChannelId: number;
    allCustomers: number;
    employeeId: number;
    quantity: number;
    customerOutletName: string;
    customerCodeName: string;
    outletCodeName: string;
    groupCodeName: string;
    groupName: string;
    channelName: string;
    ChannelSubChannelIds: string;
    ChannelSubChannelDescriptions: string;
    constructor() {
        this.salesRestrictionId = -1;
        this.customerId = -1;
        this.outletId = -1;
        this.groupId = -1;
        this.channelId = -1;
        this.subChannelId = -1;
        this.allCustomers = -1;
        this.employeeId = -1;
        this.quantity = -1;
    }
}

export class CustomerSalesRestrictionDetail {
    salesRestrictionId: number;
    itemId: number;
    packId: number;
    quantity: number;
    itemGroupId: number;
    constructor() {
        this.salesRestrictionId = -1;
        this.itemId = -1;
        this.packId = -1;
        this.quantity = -1;
        this.itemGroupId = -1;
    }
}