import { CustomerOutletModel } from "./outlet.model";
import { TextLanguage } from "../general/textLanguage.model";
import { ItemPackModel } from "../Item/item.model";


export class CustomerModel {

  customerIdSignature: string;
  customerId: number;
  customerCode: string;
  customerName: string;
  customerCodeName: string;
  phone: string;
  fax: string;
  email: string;
  streetId: string;
  streetNumber: number;
  isNewCustomer: boolean;
  contractNumber: string;
  collectorId: number;
  currencyId: number;
  isDirectSales: boolean;
  currencyDescription: string;
  outlets: CustomerOutletModel[];
  account: any;
  accountsList: any[];
  descriptionLanguages: TextLanguage[];
  customerAttachmentsBasePath: string = "";
  isDefault: boolean;
  allowPayAllOutlets: boolean;
  employeeId: number;
  hasPrivilegeOnPaymentTermDivision: boolean;
  hasPrivilegeOnOnHoldDivision: boolean;
  customerPackBarcodeList: ItemPackModel[] = [];
  outletPayersList: any[] = [];
  paymentTermId: number = 0;
  maxCustomerCode: string = '';
  maxOutletCode: string = '';
  exportCustomer:boolean

  CustomerModel() {
    this.customerId = -1;
    this.outlets = [];
    this.streetNumber = -1;
    this.collectorId = -1;
    this.currencyId = -1;
    this.isNewCustomer = false;
    this.descriptionLanguages = [];
    this.accountsList = [];
    this.isDefault = false;
    this.allowPayAllOutlets = false;
    this.employeeId = -1;
    this.exportCustomer=false
  }
}
