import { TextLanguage } from "../general/textLanguage.model";

export class DocumentTypeProofsModel {
  proofId?: number = -1;
  documentTypeId: number = -1;
  description: string = "";
  isEdited: boolean = false;
  selectedBeforeProofMethodTypes: ProofMethodsModel[] = [];
  selectedAfterProofMethodTypes: ProofMethodsModel[] = [];
}

export class ProofMethodsModel {
  //proofId?: number = -1;
  DocumentTypeId: number = -1;
  ProofMethodId: number = -1;
  ProofMethodTypeId: number = -1;
  MaxValue: number = -1;
  MinValue: number = -1
  CreatedBy: number = -1;
  UpdatedBy: number = -1;
  Description: string = "";
  IsBeforeSaving: boolean = false;
}

export class ProofModel {
  proofId: number = -1;
  proofName?: string;
  organizationId: number = -1;
  organizationCodeName: string;
  descriptionLanguages: TextLanguage[];
  isNew: boolean;
  documentTypeProofs: DocumentTypeProofsModel[];
  assignmentList: ProofAssigment[];
  employeesList: any[];
  securityGroupsList: any[];
  constructor() {
    this.proofId = -1;
    this.organizationId = -1;
    this.descriptionLanguages = [];
    this.isNew = true;
    this.employeesList = [];
    this.securityGroupsList = [];
  }
}

export class ProofAssigment {
  // Proof level:
  proofAssignmentId?: number = -1;
  proofId: number = -1;
  documentTypeId: number = -1;
  proofMethodId: number = -1;
  documentTypeName?: string;
  proofStatusId: number = -1;

  // Assignment parties level:
  //Customer:
  customerId?: number = -1;
  outletId?: number = -1;
  customerOutletName?: string;
  //Channel
  channelId?: number = -1;
  subChannelId?: number = -1;
  channelName?: String;
  //Groups
  groupId?: number = -1;
  groupName?: String;
  constructor() {
    this.proofId = -1;
    this.documentTypeId = -1;
    this.proofAssignmentId = -1
    this.groupId = -1;
    this.channelId = -1;
    this.customerId = -1;
    this.subChannelId = -1;
    this.proofMethodId = -1;
  }
  // hannelId: -1
  // channelName: "-----"
  // customerId: 50000001
  // customerOutletName: "Customer 1 - Outlet 1"
  // documentTypeId: 3
  // documentTypeName: "Cash Return"
  // enableEditMode: false
  // groupId: -1
  // groupName: "-----"
  // isMandatory: "0"
  // isVisible: "0"
  // outletId: 1
  // proofMethodId: 1
  // proofMethodName: "ImageProof"
  // proofStatusId: 1
  // subChannelId: -1


}
