import { CustomerValidations as CustomerValidationsModel } from "../enums/customer-validations";
import { CustomerGroupModel } from "./customer.group.model";
import { TerritoryModel } from "../route/territory.model";
import { RouteModel } from "../route/route.model";
import { DataActions } from "../enums/data-actions.enum";
import { TextLanguage } from "../general/textLanguage.model";
import { DateTimeModel } from "../dateTimeModel/date-time.model";

export class
CustomerOutletModel {
  isValidDelete:boolean;
  customerIdSignature: string;
  outletIdSignature: string;
  customerOutletSignature: string;
  outletCode: string = '';//ok
  outletName: string = '';//ok
  extraInfoLink: string = '';//ok
  outletCodeName: string = '';
  barcode: string;
  customerTypeId: number = 1;//ok
  customerStatusId: number = -1;
  paymentTermId: number = 0;//ok
  billsNumber: number = 0;//ok
  currencyId: number;
  groups: CustomerGroupModel[];
  territories: TerritoryModel[];
  customerStatus: CustomerStatusModel[];
  routes: RouteModel[];
  fax: string = '';//ok
  email: string = '';//ok
  phone: string = '';//ok
  streetId: string = "";
  address: string = '';//ok
  address2: string = '';//ok
  inactive: boolean = false;//ok
  onHold: boolean = false;//ok
  isHighlighted: boolean = false;//ok
  taxable: boolean = false;//ok
  commissionerOfReceipt: string = '';//ok
  vendorNumber: string = '';//ok
  taxNumber: string = '';//ok
  gln: string = '';
  tradeLicenceName: string = '';
  tradeLicenceNumber: string = '';
  tradeLicenceExpiryDate?: DateTimeModel;
  tradeLicenceExpiryDateModel?: DateTimeModel;
  customerClassId: number = -1;//ok
  customerSubClassId: number = -1;//ok
  notes: string = '';//ok
  dataAction: DataActions = DataActions.NoChange;
  customerValidations: CustomerValidationsModel;
  attachedFiles: any;
  machineTypeId: number;
  machineData: any;

  account: any;
  accountsList: any[];
  outletId: number;
  customerId: number;
  iCashBalance: number;
  hasICashBalance: boolean;

  descriptionLanguages: TextLanguage[];
  routesList: RouteModel[];
  outletDivisionPaymentTermList: any[];
  gpsLatitude: string;
  gpsLongitude: string;
  addressLanguages: TextLanguage[];
  address2Languages: TextLanguage[];
  areaId: string;
  cityId: string;
  stateId: string;
  countryId: string;
  zipCode: string;
  operatorName: string;
  operatorPassword: string;
  orginalOperatorName: string;
  orginalOperatorPassword: string;
  operatorId: number = -1;
  tempOperatorId: number = -1;
  matchWithExistsOperator: boolean;
  isLockedOperator: boolean;
  orginalIsLockedOperator: boolean;
  isNeedToSaveOperator: boolean;
  isMain: boolean;
  customerOutletContacts: CustomerOutletContactModel[];
  outletAttachments: string[];
  dummyOutletID: number = -1;
  selected: boolean;
  territoryRouteList: any[];
  territoryIdList: any[];
  hasPrivilegeOnPaymentTermDivision: boolean;
  hasPrivilegeOnOnHoldDivision: boolean;
  onHoldDivisionsList: any[];
  isThereAnyGroupAchievementPromotions?: boolean;
  includedGroupAchievementPromotions?: any[];
  excludedGroupAchievementPromotions?: any[];
  customerGroupsInDB?: any[];
  landmark: string = '';
  salesDistributionChannels: any[];
  buildingNumber: string;
  warehouseId: number;
  warehouseOrganizationId: number;
  companyPrefix: number;
  isBusinessCustomer: boolean;
  isVendingMachine: boolean;
  CustomerOutletModel() {
    this.outletDivisionPaymentTermList = [];
    this.routesList = [];
    this.hasICashBalance = false;
    this.outletId = -1;
    this.customerId = -1;
    this.groups = [];
    this.customerValidations = new CustomerValidationsModel();
    this.outletCodeName = '';
    this.streetId = "";
    this.customerStatusId = -1;
    this.customerStatus = [];
    this.customerIdSignature = '';
    this.outletIdSignature = '';
    this.customerOutletSignature = '';
    this.territories = [];
    this.routes = [];
    this.dataAction = DataActions.NoChange;
    this.machineTypeId = -1;
    this.descriptionLanguages = [];
    this.gln = '';
    this.gpsLatitude = '';
    this.gpsLongitude = '';
    this.addressLanguages = [];
    this.address2Languages = [];
    this.areaId = "";
    this.cityId = "";
    this.stateId = "";
    this.countryId = "";
    this.operatorId = -1;
    this.customerOutletContacts = [];
    this.outletAttachments = [];
    this.selected = false;
    this.onHoldDivisionsList = [];
    this.isThereAnyGroupAchievementPromotions = false;
    this.customerGroupsInDB = [];
    this.landmark = '';
    this.salesDistributionChannels = [];
    this.warehouseId = -1;
    this.warehouseOrganizationId = -1;
    this.isBusinessCustomer = false;
    this.isVendingMachine = false;
    this.isValidDelete = true
  }

}

export class CustomerOutletContactModel {
  contactId: number;
  contactName: string;
  mobile: number;
  phone: number;
  fax: number;
  street: number;
  streetName: string;
  address: string;
  email: string;
  contactDescriptionsLanguages: TextLanguage[];
  addressDescriptionsLanguages: TextLanguage[];
  languageId: number;

  CustomerOutletContactModel() {
    this.contactId = -1;
    this.contactName = '';
    this.mobile = 0;
    this.phone = 0;
    this.fax = 0;
    this.street = 0;
    this.streetName = '';
    this.address = '';
    this.email = '';
    this.contactDescriptionsLanguages = [];
    this.addressDescriptionsLanguages = [];
    this.languageId = -1;
  }
}
export class CustomerStatusModel {
  customerStatusId: number;
  CustomerStatusName: string;
  organizationId: string;
}
