import { TextLanguage } from "../general/textLanguage.model";

export class PayerAccountModel {

  payerId: number;
  accountId: number;
  appliedCustomers: any[];
  appliedGroups: any[];
  divisions: any[];
  payerName: string;
  payerCode: string;
  languageDescriptions: TextLanguage[];
  creditLimit: number;
  balance: number;
  groupCodeName: string;
  customerCodeName: string;
  outletCodeName: string;
  divisionCodeName: string;
  organizationCodeName: string;
  payerCodeName: string;
  customerId: number;
  organizationId: number;
  currencyId: number;
  outletId: number;
  customerGroupId: number;
  groupId: number;
  divisionId: number;
  isDisabledInput: boolean; // disable payer selection in case has transactions or out of org access
  PayerAccountModel() {
    this.payerId = -1;
    this.accountId = -1;
    this.appliedCustomers = [];
    this.appliedGroups = [];
    this.divisions = [];
    this.payerName = '';
    this.payerCode = '';
    this.languageDescriptions = [];
    this.creditLimit = 0;
    this.balance = 0;
    this.groupCodeName = '';
    this.customerCodeName = '';
    this.outletCodeName = '';
    this.divisionCodeName = '';
    this.organizationCodeName = '';
    this.payerCodeName = '';
    this.customerId = -1;
    this.organizationId = -1;
    this.currencyId = -1;
    this.outletId = -1;
    this.customerGroupId = -1;
    this.groupId = -1;
    this.divisionId = -1;
    this.isDisabledInput = false;

  }
}
