import { DocumentSequence } from "./document-sequence.model";
import { DocumentTypes } from "../enums/document-types.enum";
import { DocumentSequencePrefixes } from "./document-sequence-prefix.model";
import { ConstantDocumentSequenceDescription } from "../constants/constant-document-sequence-description";

export class EmployeeDocumentSequence {
  employeeId: number;
  divisionId: number;
  documentSequenceList: DocumentSequence[] = [];
  constructor(employeeId: number, divisionId: number) {
    this.employeeId = -1;
    this.divisionId = -1;
    if (employeeId != null && divisionId != null) {
      this.employeeId = employeeId;
      this.divisionId = divisionId;
    }
    this.documentSequenceList = [];
    Object.values(DocumentTypes).forEach(document => {
      if (parseInt(document.toString(), 10) >= 0) {
        const documentSequenceObject: DocumentSequence = new DocumentSequence();
        switch (document) {
          case DocumentTypes.Invoice.valueOf():
            documentSequenceObject.key = DocumentTypes.Invoice;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.InvoicePrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.Invoice;
              documentSequenceObject.value = "";
              documentSequenceObject.suggestedValue = "";
              this.documentSequenceList.push(documentSequenceObject);
            break;

          case DocumentTypes.Return.valueOf():
            documentSequenceObject.key = DocumentTypes.Return;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.ReturnPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.Return;
            break;

          case DocumentTypes.Order.valueOf():
            documentSequenceObject.key = DocumentTypes.Order;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.OrderPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.Order;
              documentSequenceObject.value = "";
              documentSequenceObject.suggestedValue = "";
              this.documentSequenceList.push(documentSequenceObject);
            break;

          case DocumentTypes.WarhouseTransaction.valueOf():
            documentSequenceObject.key = DocumentTypes.WarhouseTransaction;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.WarehouseTransactionPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.WarehouseTransaction;
            break;

          case DocumentTypes.CreditNote.valueOf():
            documentSequenceObject.key = DocumentTypes.CreditNote;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.CreditNotePrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.CreditNote;
            break;

          case DocumentTypes.DebitNote.valueOf():
            documentSequenceObject.key = DocumentTypes.DebitNote;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.DebitNotePrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.DebitNote;
            break;

          case DocumentTypes.Collection.valueOf():
            documentSequenceObject.key = DocumentTypes.Collection;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.PaymentPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.Payment;
            break;

          case DocumentTypes.Sample.valueOf():
            documentSequenceObject.key = DocumentTypes.Sample;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.SamplePrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.Sample;
            break;

          case DocumentTypes.NewCustomerCode.valueOf():
            documentSequenceObject.key = DocumentTypes.NewCustomerCode;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.DocumentPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.NewCustomerCode;
              documentSequenceObject.value = "";
              documentSequenceObject.suggestedValue = "";
              this.documentSequenceList.push(documentSequenceObject);
            break;

          case DocumentTypes.AppliedPayment.valueOf():
            documentSequenceObject.key = DocumentTypes.AppliedPayment;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.ApplyingPaymentsPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.ApplyingPayments;
            break;

          case DocumentTypes.Replenish.valueOf():
            documentSequenceObject.key = DocumentTypes.Replenish;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.ReplenishPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.Replenish;
            break;

          case DocumentTypes.Remove.valueOf():
            documentSequenceObject.key = DocumentTypes.Remove;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.RemovePrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.Remove;
            break;

          case DocumentTypes.Settelment.valueOf():
            documentSequenceObject.key = DocumentTypes.Settelment;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.SettlementPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.Settlement;
            break;

          case DocumentTypes.OrderInvoice.valueOf():
            documentSequenceObject.key = DocumentTypes.OrderInvoice;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.OrderInvoicePrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.OrderInvoice;
              documentSequenceObject.value = "";
              documentSequenceObject.suggestedValue = "";
              this.documentSequenceList.push(documentSequenceObject);
            break;

          case DocumentTypes.ReturnOrder.valueOf():
            documentSequenceObject.key = DocumentTypes.ReturnOrder;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.ReturnOrderPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.ReturnOrder;
            break;

          case DocumentTypes.ContractedFOC.valueOf():
            let ChangeFOCCaptionToValue = 0;
            if (ChangeFOCCaptionToValue === 1) {
              documentSequenceObject.prefix =
                DocumentSequencePrefixes.COSPrefix;
            } else if (ChangeFOCCaptionToValue === 2) {
              documentSequenceObject.prefix =
                DocumentSequencePrefixes.DisplayRentalPrefix;
            } else {
              documentSequenceObject.prefix =
                DocumentSequencePrefixes.ContractedFOCPrefix;
            }
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.ContractedFOC;
            documentSequenceObject.key = DocumentTypes.ContractedFOC;
            break;

          case DocumentTypes.UnlimitedFOC.valueOf():
            documentSequenceObject.key = DocumentTypes.UnlimitedFOC;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.UnlimitedFOCPrefic;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.UnlimitedFOC;
            break;

          case DocumentTypes.FixedIncentive.valueOf():
            documentSequenceObject.key = DocumentTypes.FixedIncentive;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.FixedIncentivePrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.FixedIncentive;
            break;

          case DocumentTypes.VariableIncentive.valueOf():
            documentSequenceObject.key = DocumentTypes.VariableIncentive;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.VariableIncentivePrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.VariableIncentive;
            break;

          case DocumentTypes.OrgCreditNote.valueOf():
            documentSequenceObject.key = DocumentTypes.OrgCreditNote;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.OrgCreditNotePrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.OrgCreditNote;
            break;

          case DocumentTypes.OrgDebitNote.valueOf():
            documentSequenceObject.key = DocumentTypes.OrgDebitNote;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.OrgDebitNotePrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.OrgDebitNote;
            break;

          case DocumentTypes.PurchaseOrder.valueOf():
            documentSequenceObject.key = DocumentTypes.PurchaseOrder;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.PurchaseOrderPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.PurchaseOrder;
            break;

          case DocumentTypes.PrisonExpenses.valueOf():
            documentSequenceObject.key = DocumentTypes.PrisonExpenses;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.PrisonExpensesPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.PrisonExpenses;
            break;

          case DocumentTypes.GuaranteesExpenses.valueOf():
            documentSequenceObject.key = DocumentTypes.GuaranteesExpenses;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.GuaranteesExpensesPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.GuaranteesExpenses;
            break;

          case DocumentTypes.GiftVoucher.valueOf():
            documentSequenceObject.key = DocumentTypes.GiftVoucher;
            documentSequenceObject.prefix =
              DocumentSequencePrefixes.GiftVoucherPrefix;
            documentSequenceObject.description =
              ConstantDocumentSequenceDescription.GiftVoucher;
            break;

          case DocumentTypes.ICashTransaction.valueOf():
            documentSequenceObject.key = DocumentTypes.ICashTransaction;
            documentSequenceObject.prefix = DocumentSequencePrefixes.ICashTransactionPrefix;
            documentSequenceObject.description = ConstantDocumentSequenceDescription.ICashTransaction;
            break;
          case DocumentTypes.ICashReversal.valueOf():
            documentSequenceObject.key = DocumentTypes.ICashReversal;
            documentSequenceObject.prefix = DocumentSequencePrefixes.ICashReversalPrefix;
            documentSequenceObject.description = ConstantDocumentSequenceDescription.ICashReversal;
            break;
          case DocumentTypes.DeliveryNote.valueOf():
            documentSequenceObject.key = DocumentTypes.DeliveryNote;
            documentSequenceObject.prefix = DocumentSequencePrefixes.DeliveryNotePrefix;
            documentSequenceObject.description = ConstantDocumentSequenceDescription.DeliveryNote;
            documentSequenceObject.value = "";
            documentSequenceObject.suggestedValue = "";
            this.documentSequenceList.push(documentSequenceObject);
            break;
          case DocumentTypes.Promotion.valueOf():
            documentSequenceObject.key = DocumentTypes.Promotion;
            documentSequenceObject.prefix = DocumentSequencePrefixes.PromotionPrefix;
            documentSequenceObject.description = ConstantDocumentSequenceDescription.Promotion;
            documentSequenceObject.value = "";
            documentSequenceObject.suggestedValue = "";
            this.documentSequenceList.push(documentSequenceObject);
            break;
          case DocumentTypes.CustomerCode.valueOf():
            documentSequenceObject.key = DocumentTypes.CustomerCode;
            documentSequenceObject.prefix = DocumentSequencePrefixes.CustomerCodePrefix;
            documentSequenceObject.description = ConstantDocumentSequenceDescription.MaxCustomerCode;
            documentSequenceObject.value = "";
            documentSequenceObject.suggestedValue = "";
            this.documentSequenceList.push(documentSequenceObject);
            break;
          case DocumentTypes.CreditNoteRequest.valueOf():
              documentSequenceObject.key = DocumentTypes.CreditNoteRequest;
              documentSequenceObject.prefix = DocumentSequencePrefixes.CreditNoteRequestPrefix;
              documentSequenceObject.description = ConstantDocumentSequenceDescription.CreditNoteRequest;
            break;
        }

      }
    });
  }
}
