import { PaymentTypes } from "../enums/payment-types.enum";
import { DateTimeModel } from "../dateTimeModel/date-time.model";

export class PaymentModel {
  customerId: number;
  outletId: number;
  createdBy: number;
  organizationId: number;
  accountId: number;
  divisionId: number;
  employeetId: number;

  sourceTransactionId: string;
  creditNoteId: string;
  bankId: number;
  branchId: number;
  voucherNumber: string;
  customerPaymentId: string;
  appliedPaymentId: string;
  //   PaymentStatusId : PaymentStatus 
  paymentTypeId: PaymentTypes
  //   PaymentDate
  paymentDateModel: DateTimeModel;
  //   VoucherDate
  voucherDateModel: DateTimeModel;
  voucherOwner: string;
  remainingAmount: number;
  appliedAmount: number
  collectionDiscount: number;
  currencyId: number;
  selectedCurrencyId: number;
  secondCurrencyId: number;
  secondCurrencyAmount: number;
  exchangeRate: number;
  notes: string;
  isPrinted: boolean;
  isTransRemainingAffected: boolean;
  autoGeneratedByExchange: boolean;
  routeHistoryId: number;

  customerNameCode: string;
  outletNameCode: string;
  employeeNameCode: string;
  paymentTypeName: string;
  paymentStatusName: string;
  bankName: string;
  branchName: string;

  constructor() {
    this.customerId = -1;
    this.outletId = -1;
    this.employeetId = -1;
    this.divisionId = -1;
    this.createdBy = -1;
    this.organizationId = -1;
    this.accountId = -1;
    this.bankId = -1;
    this.branchId = -1;
    this.notes = '';
    this.voucherNumber = '';
    this.secondCurrencyId = -1;
    this.selectedCurrencyId = -1;
    this.routeHistoryId = -1;
    this.paymentDateModel = new DateTimeModel();
    this.voucherDateModel = new DateTimeModel();
    this.voucherOwner = '';
  }
}
