import { DateTimeModel } from "../dateTimeModel/date-time.model";

export class SalesRestrictionModel {
  salesRestrictionID: number;
  createdBy: number;
  updatedBy: number;
  itemID: number;
  packID: number;
  itemGroupId: number;


  salesRestrictionQuantity: number;

  salesRestrictionCode: string;

  creationDate?: DateTimeModel;
  updateDate?: DateTimeModel;
  startDate: Date;
  endDate: Date;
  fromToDate: any[];

  employeeIDs: any[];
  outletIDs: any[];
  appliedOrganizations: any[];

  isEditMode: boolean;
  isInactivate: boolean;
  periodTypeId: number;
  isQuantity: boolean;
  constructor() {
    this.salesRestrictionID = -1;
    this.createdBy = -1;
    this.updatedBy = -1;
    this.itemID = -1;
    this.packID = -1;
    this.itemGroupId = -1;
    this.salesRestrictionQuantity = 0;
    this.salesRestrictionCode = '';
    this.employeeIDs = [];
    this.outletIDs = [];
    this.appliedOrganizations = [];
    this.startDate = new Date();
    this.endDate = new Date();
    this.isEditMode = false;
    this.isInactivate = false;
    this.periodTypeId = -1;
    this.isQuantity = false;
  }
}
