import { OrderStatus } from "../enums/order-status.enum";
import { DateTimeModel } from "../dateTimeModel/date-time.model";
import { OrderOperation } from "../enums/order-operation .enum";
import { FormProcessMode } from "../enums/form-process-mode.enum";
import { IColumnProperties } from "./table-properties.interface";

export interface CustomListFilter {
  pageSize: number;
  page: number;
  sortBy?: string;
  isSortAscending?: boolean;
  searchFilter?: string;
  groupId?: number;
  territoryId?: number;
  classId?: number;
  isWitGetTerritories?: boolean;
}

export interface OrderListFilter {
  customListFilter?: CustomListFilter;
  orderStatus?: OrderStatus;
  orderId?: string;
  scanByOrderId?: string;
  divisionId?: number;
  employeeId?: number;
  areaId?: number;
  streetId?: number;
  customerId?: number;
  territoryId?: number;
  routeId?: number;
  customerStatusId?:number;
  outletId?: number;
  itemId?: number;
  orderDateRange?: DateTimeModel[];
  desiredDeliveryDateRange?: DateTimeModel[];
  assignmentDateRange?: DateTimeModel[];
  orderSignature?: string;
  getAll?: boolean;
  orderOperation?: OrderOperation;
  isViewMode?: boolean;
  driverId?: number;
  getAllData?: boolean;
  RejectDateRange?: DateTimeModel[];
  employeeCode?: string;
  excludeLinkedWithSSCC?: boolean;
  orderTypeId?: number;
  organizationId?: number;
  isBundle?: boolean;
  isVendingMachine?: boolean;
  hasUnlimitedFOC?: boolean;
  tableName?: string;
  exportColumns?: IColumnProperties[];
  warehouseId?:number;
  isFromReassignButton? : boolean;
}
export interface ConsignmentOrderFilter {
  orderId?: string;
  customerId?: number;
  outletId?: number;
  divisionId?: number;
  customListFilter?: CustomListFilter;
  orderStatusId?: number;
  orderDateRange?: DateTimeModel[];
  isCreation: boolean;
  consignmentOrderTypeId?:number;
}

export interface warehouseFilter {
  customListFilter?: CustomListFilter;
  divisionId?: number;
  employeeId?: number;
  refWarehouseId?: number;
  warehouseId?: number;
  warehouseTransactionStatusId?: number;
  transactionId?: string;
  transactionDate: DateTimeModel;
  processMode: FormProcessMode;
  transactionDateRange?: DateTimeModel[];
  receivingDateRange?: DateTimeModel[];
  isMoveOrder?: boolean;
  onlyGetLinkedToOrder?: boolean;
  getAllData?: boolean;
  includeTripOperations?: boolean;
  securityGroupId?: number;
}

export interface DataFilter extends CustomListFilter {
  customListFilter?: CustomListFilter;
  vehicleId?: number;
  transactionDateModel?: DateTimeModel;
  divisionId?: number;
  itemCategoryId?: number;
  active?: boolean;
  showPacks?: boolean;
  territoryId?: number;
}

export interface ITextInput {
  formControlName: string;
  label: string;
  placeHolder: string;
  isRequierd?: boolean;
  isTextArea?: boolean;
}
