import { MatPaginatorIntl } from '@angular/material/paginator';
import { Injectable } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../constants/constant-message';

@Injectable()
export class CustomPaginatorIntl extends MatPaginatorIntl {
  constructor(private translateService: TranslateService){
    super();
  }
  itemsPerPageLabel = this.translateService.instant(ConstantMessages.ItemPerPages) ; // Customize this label as per your requirement

  getRangeLabel = (page: number, pageSize: number, length: number) => {
    if (length === 0 || pageSize === 0) {
      return `0 ${this.translateService.instant(ConstantMessages.Of)} ${length}`;
    }
    length = Math.max(length, 0);
    const startIndex = page * pageSize + 1;
    const endIndex = startIndex < length ? Math.min(startIndex + pageSize - 1, length) : startIndex + pageSize - 1;
    return `${startIndex} – ${endIndex} ${this.translateService.instant(ConstantMessages.Of)} ${length}`;
  };
}
