import { RowOperation, MultiSelectionOperation } from '../enums/shared-table-operation.enum';
import { CommonButtonStyles } from '../enums/common-button-styles.enum';

export interface ITableProperties {
  pageSizeOptions?: number[];
  columns: IColumnProperties[];
  pageSize: number;
  showPaginator: boolean;
  showSearch: boolean;
  isOnline: boolean;
  showSearchBtn?: boolean;
  showNewBtn?: boolean;
  newBtnCaption?: string;
  importBtnCaption?: string;
  exportBtnCaption?: string;
  showExportBtn?: boolean;
  showImport?: boolean;
  showExport?: boolean;
  showExtraBtn?: boolean;
  extraBtnCaption?: string;
  extraBtnIcon?: string;
  showOptionPerLine?: boolean;
  showOptionOnKey?: string;
  openFilterDirectly?: boolean;
  isMultiSelection?: boolean;
  specificActionWhenCheckAll?: boolean;
  specificActionWhenCheckRow?: boolean;
  showOptionButtonsSeparated?: boolean;
  rowOperations: IRowOperationProperties[];
  multiSelectionOperations: ISelectionProperties[];
  isAllowDragDrop?: boolean;
  showAllButtons?: boolean;
  showEditButton?: boolean;
  clearSearchBoxAfterFinish?: boolean;
  SearchBoxLabel?: string;
  isMultiSelectionDialog?: boolean;
  isConfigurationScreen?: boolean;
  showSaveBtn?: boolean;
  showCloseBtn?: boolean;
  buttonsZeroPadding?: boolean;
}

export interface IColumnProperties {
  title: string;
  key: string;
  isSortable: boolean;
  width?: string;
  isDate?: boolean;
  isExpiryDate?: boolean;
  numberOfDigits?: boolean;
  zeroDigits?: boolean;
  numberOfStockDigits?: boolean;
  useTranslate?: boolean;
  isEditable?: boolean;
  isEditablePerRow?: boolean;
  isNgSelect?: boolean;
  isMultiSelect?: boolean;
  isEditableWithRollback?: boolean;
  disableInputBasedOnProperty?: boolean; // will disable/enable ng selecte based on specified promperty name
  ShowDisabledComboAsInput?: boolean; // will show input text instead ng select based on specified promperty name
  inputPropertyName?: string;
  disableInputPropertyName?: string;
  isChart?: boolean,
  chartNeedleKey?: string,
  isIcon?: boolean;
  iconColor?: string;
  isMultiSelectDialog?: boolean;
  isPlusMinusValue?: boolean;
  isPromotionPrerequisite?: boolean; // if true, the input will ignore (allowFractionsInQuantity) configuration value
  isImageURL?: boolean;
  isColoring?: boolean;
}

export interface IRowOperationProperties {
  title: string;
  operation: RowOperation;
  icon: string;
  color: string;
  highlightBasedOnKeyName? :string;
  showWhenKeyValueTrue?: boolean,
  showWhenKeyValueFalse?: boolean,
  showHideOptionPerLine?: boolean,
  controlKeyName?: string
}

export interface ISelectionProperties {
  title: string;
  operation: MultiSelectionOperation;
  icon: string;
  color?: string;
  style?: CommonButtonStyles;
}
