import { ItemPackModel } from "../Item/item.model";
import { CustomerOutletModel } from "../customer/outlet.model";
import { FormProcessMode } from "../enums/form-process-mode.enum";
import { OrderStatus } from "../enums/order-status.enum";

export class TransationCommonData {
  warehouseId:number;
  customerId: number;
  customerRef: string;
  outletId: number;
  divisionId: number;
  employeeId: number;
  soldItems: ItemPackModel[];
  promotedItems: ItemPackModel[];
  customerPromotions: any[];
  promotionsForAllLevels: any[];
  promotionGroupLevels: any[];
  lastInvoicePromotionsList: any[];
  loyaltyPromotionsList: any[];
  netTotal: number;
  roundingDifference: number;
  includedTaxAmount: number;
  tax: number;
  calculatedRetailTax: number;
  grossTotal: number;
  headerDiscount: number;
  exchangeRate: number;
  outlet: CustomerOutletModel;
  itemFormProcessMode: FormProcessMode;
  orderStatus: OrderStatus;
  amountToCheckInCreditLimit: number;
  isEditMode: boolean;
  noDocumentSequance: boolean;
  dontCheckLastInvoice: boolean;
  dontCheckLoyalty: boolean;
  areAllItemDiscountsAdded: boolean;
  draftTransactionId: string;
  orderId: string;
  isDeliveryHasRelatedToTarget: boolean;
  areDetailsFilled: boolean;
  promotionLevelId: number;
  orderTypeId: number;
  onlyProductDiscount: boolean;
  isThereAnyProductDiscountDefined: boolean;
  isSecondLevelProductDiscountTaken = false;
  notSelectedFirstLevelLastInvoice: any[];
  quanityProductDiscountCount: number;
  discountOrFreeItemsProductDiscountCount: number;
  productDiscountFirstLevelList: any[];
  productDiscountSecondLevelList: any[];
  productPromotionLevelId: number;
  shipTo: string;
  routeId: number;
  returnId: string;
  isExchangeInvoice: boolean;
  promotionsGroupPriorities: any[];
  salesMode: number;
  sdcId: number;
  getApplicableContractedFOCsOnly: boolean;
  contractedFOCs: any[];
  isBundle: boolean;
  orderItems: any[];
  includeInActive: boolean;
  isTest: boolean;

  constructor() {
    this.draftTransactionId = '';
    this.promotionLevelId = 1;
    this.onlyProductDiscount = true;
    this.isThereAnyProductDiscountDefined = false;
    this.isSecondLevelProductDiscountTaken = false;
    this.quanityProductDiscountCount = 0;
    this.discountOrFreeItemsProductDiscountCount = 0;
    this.soldItems = [];
    this.customerId = -1;
    this.outletId = -1;
    this.routeId = -1;
    this.productDiscountFirstLevelList = [];
    this.productDiscountSecondLevelList = [];
    this.productPromotionLevelId = 1;
    this.notSelectedFirstLevelLastInvoice = [];
    this.shipTo = '';
    this.returnId = '';
    this.isExchangeInvoice = false;
    this.promotionsGroupPriorities = [];
    this.salesMode = -1;
    this.sdcId = -1;
    this.getApplicableContractedFOCsOnly = false;
    this.contractedFOCs = [];
    this.isBundle = false;
    this.orderItems = [];
    this.includeInActive = false;
    this.isTest = false;
    this.warehouseId=-1
  }
}
