import { DateTimeModel } from '../dateTimeModel/date-time.model';
import { CustomerValidations } from '../enums/customer-validations';
import { CustomerOutletModel } from '../customer/outlet.model';
import { ItemPackModel } from '../Item/item.model';
import { TransactionType } from '../enums/transaction-type.enum';
import { DocumentTypes } from '../enums/document-types.enum';
import { TransactionMainTypes } from '../enums/transaction.main.types.enum';
import { TransactionStatues } from '../enums/transaction.statuses.enum';
import { SalesModes } from '../enums/sales.modes.enum';
import { TransactionCreationReason } from '../enums/transaction-creation-reason.enum';
import { PaymentTypes } from '../enums/payment-types.enum';

export class TransactionModel {

  transactionId: string;
  invoiceNumber: string;
  employeeId: number;
  divisionId: number;
  warehouseId: number;
  employeeName: string;
  employeeCodeName: string;
  divisionName: string;
  divisionCodeName: string;
  warehouseName: string;
  warehouseCodeName: string;
  posted: boolean;
  routeHistoryId: number;
  transactionMainTypes: TransactionMainTypes;
  transactionStatusId: number;
  transactionType: TransactionType;
  documentType: DocumentTypes;
  salesModes: SalesModes;
  transactionTypeId: number;
  creationReason: TransactionCreationReason;
  returnId: string;
  //  DateTime CreatedDate
  //  DateTime UpdatedDate
  //  DateTime transactionDate

  updatedBy: number;
  sourceTransactionId: string;
  routeId: number;
  supervisorId: number;
  helperId: number;
  driverId: number;
  salesRepId: number;
  salesManagerId: number;
  isUpdatedInFO: boolean;
  visitNo: number;

  customerId: number;
  outletId: number;
  mainOutletId: number;
  createdBy: number;
  organizationId: number;
  accountId: number;
  signature: string;
  transactionDateModel: DateTimeModel;
  remainingAmount: number;
  appliedAmount: number;
  netTotal: number;
  roundingDifference: number;
  includedTaxAmount: number;
  grossTotal: number;
  tax: number;
  discount: number;
  calculatedRetailTax: number;
  promotedDiscount: number;
  collectionDiscount: number;
  returnNetTotal: number;
  returnGrossTotal: number;
  returnTax: number;
  returnDiscount: number;
  returnCalculatedRetailTax: number;

  currencyId: number;
  selectedCurrencyId: number;
  customerName: string;
  outletName: string;
  outletCode: string;
  customerCodeName: string;
  outletCodeName: string;
  voided: boolean;
  voidedString: string;
  customerOutletHeader: string;
  gPSLatitude: number;
  gPSLongitude: number;
  notes: string;
  exchangeRate: number;
  lPONumber: string;
  refOrderId: string;
  refWarehouseId: string;
  soldBy: string;
  isPromotionTaken: boolean;
  isChecked: boolean;
  outlet: CustomerOutletModel;
  customerValidations: CustomerValidations
  allItems: ItemPackModel[];
  soldItems: ItemPackModel[];
  promotedItems: ItemPackModel[];
  returnItems: ItemPackModel[];
  fOCItems: ItemPackModel[];
  customerPromotions: any[];
  allowBatchesInItems: boolean;
  isTaxeableOutlet: boolean;
  iCashAmount: number;
  iCashBalanceBefore: number;
  iCashBalanceAfter: number;
  iCashCurrentBalance: number;
  iCashTransactionType: string;
  iCashTransactionID: string;
  deliveryNotesTransactionIds: string;
  showVoidBtn: boolean;
  showViewBtn: boolean;
  displayTransactionID: string;
  documentReasonID?: number;
  isPayment?: boolean;
  customerPaymentId: string;
  isReturn: boolean;
  isReturnExchange: boolean;
  isReturnSerials: boolean;
  // customerTransactionId: string;
  paymentTypeId?: number;
  isCustomerTransactions: boolean;
  shipTo: string;
  finalDiscount: number;
  tempreture: number;
  sdcId: number;
  packStatusId: number;

  constructor() {
    this.outlet = new CustomerOutletModel();
    this.customerValidations = new CustomerValidations();
    this.transactionDateModel = new DateTimeModel();
    this.allItems = [];
    this.soldItems = [];
    this.promotedItems = [];
    this.fOCItems = [];
    this.returnItems = [];
    this.customerPromotions = [];
    this.appliedAmount = 0;
    this.creationReason = TransactionCreationReason.Normal;
    this.allowBatchesInItems = false;
    this.deliveryNotesTransactionIds = '';
    this.showVoidBtn = false;
    this.showViewBtn = false;
    this.displayTransactionID = '';
    this.isPayment = false;
    this.isCustomerTransactions = false;
    this.shipTo = '';
    this.routeId = -1;
    this.isReturn = false;
    this.isReturnExchange = false;
    this.returnId = '';
    this.notes = '';
    this.finalDiscount = 0;
    this.tempreture = 0;
    this.sdcId = -1;
    this.roundingDifference = 0;
    this.packStatusId = -1;
    this.isReturnSerials = false;
    this.invoiceNumber = '';
  }
}
