import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Inject, Injectable } from "@angular/core";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";


@Injectable({
    providedIn: 'root'
})

export class PerformanceConfigrationService {
    private url = '';
    private httpOptions;

    constructor(
        private http: HttpClient,
        private coreSession: CoreSession,
        @Inject('BASE_URL') baseUrl: string
    ) {
        this.url = baseUrl + 'PerformanceConfiguration/';

        this.httpOptions = {
            headers: new HttpHeaders({
                'Content-Type': 'application/json',
                Authorization: 'my-auth-token'
            })
        };
    }

    
    getPerformanceConfigurationData() {
      const urlValue: string = this.url + "GetPerformanceConfigurationData";

      return this.http.post(urlValue, null).map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
    }

    getKPISubTypesForKPITypes(kpiTypeIdsList) {
    const urlValue: string = this.url + "GetKPISubTypesForKPITypes";

      return this.http.post(urlValue, kpiTypeIdsList).map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
    }

    updatePerformanceConfiguration( data) {

        const urlValue: string = this.url + "UpdatePerformanceConfiguration";

      return this.http.post(urlValue, data).map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
    }
}