import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Inject, Injectable } from "@angular/core";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../models/api-models/api-models";

@Injectable({
    providedIn: 'root'
})

export class ScorecardCustomizationService {
    private url = '';
    private httpOptions;

    constructor(
        private http: HttpClient,
        private coreSession: CoreSession,
        @Inject('BASE_URL') baseUrl: string
    ) {
        this.url = baseUrl + 'ScorecardCustomization/';

        this.httpOptions = {
            headers: new HttpHeaders({
                'Content-Type': 'application/json',
                Authorization: 'my-auth-token'
            })
        };
    }

    
    fillScorecardSharedTable(filter: any) {
        const urlValue: string = this.url + 'GetKPIScorecardList';
        return this.http.post<ResponseModel>(urlValue, filter)
          .map(response => {
            return response;
        });
    }

    getScorecardData(scorecardId : number) {
        const urlValue: string = this.url + 'GetKPIScorecardData';
        return this.http.post<ResponseModel>(urlValue,scorecardId)
          .map(response => {
            return response;
        }); 
    }

    updateScorecard(scorecardObject) {
        const urlValue: string = this.url + 'UpdateScorecard';
        return this.http.post<ResponseModel>(urlValue, scorecardObject)
          .map(response => {
            return response;
        }); 
    }

    saveScorecard(scorecardObject) {
        const urlValue: string = this.url + 'InsertScorecard';
        return this.http.post<ResponseModel>(urlValue, scorecardObject)
          .map(response => {
            return response;
        }); 
    }

    deleteScorecard(scorecardId:number) {
        const urlValue: string = this.url + 'DeleteScorecard';
        return this.http.post<ResponseModel>(urlValue,scorecardId)
          .map(response => {
            return response;
        });
    }

    activateScorecard(scorecardId) {
        const urlValue = this.url + 'UpdateFromDeactiveToActivateScorecard';
        return this.http.post<ResponseModel>(urlValue, scorecardId).map(
          (response) => {
            return response;
          });
    }
    
    deactivateScorecard(scorecardId) {
        const urlValue = this.url + 'UpdateFromActivateToDeactivateScorecard';
        return this.http.post<ResponseModel>(urlValue, scorecardId).map(
          (response) => {
            return response;
        });
    }
}