import { HttpClient } from '@angular/common/http';
import { Inject, Injectable } from '@angular/core';
import { ResponseModel } from '../../models/api-models/api-models';

@Injectable({
  providedIn: 'root'
})
export class CommissionCalculationService {
  private url = '';
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    this.url = baseUrl + 'CommissionCalculation/';
  }
  
  calculateCommission(commCalcObj: any) {
    const urlValue: string = this.url + 'CalculateCommission';
    return this.http.post<ResponseModel>(urlValue, commCalcObj).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return response;
      }
    );

  }
}
