import { Inject, Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { ResponseModel } from '../../../shared/models/api-models/api-models';

@Injectable({
  providedIn: 'root'
})
export class CommissionPlanService {
  private url = '';
  httpOptions;
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    this.url = baseUrl + 'CommissionPlan/';
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
        Authorization: "my-auth-token"
      })
    };
  }

  insertCommissionPlan(commissionPlanObj: any) {
    const urlValue: string = this.url + 'InsertCommissionPlan';
    return this.http.post<ResponseModel>(urlValue, commissionPlanObj).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return response;
      }
    );

  }
  getValueTypes() {
    const urlValue: string = this.url + 'GetValueTypes';
    return this.http.post<ResponseModel>(urlValue, "").map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }

  getCalculatedCommissionPlans(filter) {
    const urlValue: string = this.url + 'GetCalculatedCommissionPlans';
    return this.http.post<ResponseModel>(urlValue, filter).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  } 

  getCommissionPlansHeaders() {
    const urlValue: string = this.url + 'GetCommissionPlansHeaders';
    return this.http.post<ResponseModel>(urlValue,this.httpOptions).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  } 

  getCommissionPlanDetails(filter) {
    const urlValue: string = this.url + 'GetCommissionPlanDetails';
    return this.http.post<ResponseModel>(urlValue,filter).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  } 
  splitCommissionCalcDetailsOnDate(obj) {
    const urlValue: string = this.url + 'SplitCommissionCalcDetailsOnDate';
    return this.http.post<ResponseModel>(urlValue, obj).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }
  paidCommissionPlan(obj) {
    const urlValue: string = this.url + 'PaidCommissionPlan';
    return this.http.post<ResponseModel>(urlValue, obj).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }
}
