import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../models/api-models/api-models';
import { GeneralFilter } from '../../models/general/generalFilter.model';
import { EmployeeKeyFilter } from '../../models/employee-keys/employee-keys';

@Injectable({
    providedIn: 'root'
})
export class EchoNotificationService {
    private url = '';
    private httpOptions;

    constructor(
        private http: HttpClient,
        private coreSession: CoreSession,
        @Inject('BASE_URL') baseUrl: string
    ) {
        this.url = baseUrl + 'EchoNotification';
        this.httpOptions = {
            headers: new HttpHeaders({
                'Content-Type': 'application/json',
                Authorization: 'my-auth-token'
            })
        };
    }
    saveCustomerNotifications(echoNotificationObj: FormData) {
      const urlValue: string = this.url + "/InsertCustomerNotifications";

      return this.http.post(urlValue, echoNotificationObj).map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
    }
}
