import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { map } from "rxjs/operators";


@Injectable({
    providedIn: "root",
  })


export class CalculateTargetPromotionsService {

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "CalculateTargetPromotions/";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getCustomersWithActivePromotions(filter:any) {
    const urlValue = this.url + 'GetCustomersWithActivePromotions';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  } 

  calculateTargetPromotions(customerOutlets:any[]) {
    const urlValue = this.url + 'UpdateTargetPromotionsCalculation';
    return this.http.post<ResponseModel>(urlValue, customerOutlets).map(response => {
      return response;
    });
  }

  getCustomerTargetAndAchievementPromotions(filter:any) {
    const urlValue = this.url + 'GetCustomerTargetAndAchievementPromotions';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }

}