import { Injectable, Inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { ResponseModel } from '../../../models/api-models/api-models';
import { CoreSession } from '../../../../core/core.session';
import { TransactionModel } from '../../../models/transaction/transaction.model';

@Injectable({
  providedIn: 'root'
})
export class CreditNoteService {
  private url = '';
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string, private coreSession: CoreSession) {
    this.url = baseUrl + 'CreditNote/';
  }

  saveCreditTransaction(transaction: TransactionModel) {
    const urlValue: string = this.url + 'InsertCreditTransaction';
    return this.http.post<ResponseModel>(urlValue, transaction).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      })
  }
  voidCreditTransaction(transaction: TransactionModel) {
    const urlValue = this.url + 'VoidCreditTransaction';
    return this.http.post<ResponseModel>(urlValue, transaction).map(response => {
      return response;
    });
  }
}
