import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { TransactionModel } from "../../../models/transaction/transaction.model";
import { PaymentModel } from "../../../models/payment/payment.model";
import { ConstantMessages } from "../../../models/constants/constant-message";
import { TranslateService } from "@ngx-translate/core";


@Injectable({
    providedIn: "root",
})
export class ExchangeService {
    customerChanged = new Subject();

    private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession,
        private translateService: TranslateService
    ) {
        this.url = baseUrl + "Exchange";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }
    getExchangeTransactions(filter: any) {
        const urlValue = this.url + '/GetExchangeTransactions';
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
            return response;
        });
    }
    SaveExchangeTransaction(transaction: TransactionModel) {
        const urlValue: string = this.url + '/InsertExchangeTransaction';
        return this.http.post<ResponseModel>(urlValue, transaction).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            })
    }
    getExchangeTransactionData(signature: string) {
        const urlValue = this.url + '/GetExchangeTransactionData';
        let transaction = {
            signature: signature
        }
        return this.http
            .post<ResponseModel>(urlValue, transaction)
            .map(response => { return response; });
    }

    voidExchangeTransaction(transaction: TransactionModel) {
        (transaction);
        const urlValue = this.url + '/VoidExchangeTransaction';
        return this.http.post<ResponseModel>(urlValue, transaction).map(response => {
            return response;
        });
    }
}
