import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { TransactionModel } from "../../../models/transaction/transaction.model";
import { PaymentModel } from "../../../models/payment/payment.model";
import { ConstantMessages } from "../../../models/constants/constant-message";
import { TranslateService } from "@ngx-translate/core";


@Injectable({
  providedIn: "root",
})
export class ReturnSerialsService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession,
    private translateService: TranslateService
  ) {
    this.url = baseUrl + "ReturnSerials";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getReturnTransactions(filter: any) {
    const urlValue = this.url + '/GetReturnTransactions';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }
  SaveReturnTransaction(transaction: TransactionModel) {
    const urlValue: string = this.url + '/InsertReturnTransaction';
    return this.http.post<ResponseModel>(urlValue, transaction).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      })
  }
  getReturnTransactionData(signature: string) {
    const urlValue = this.url + '/GetReturnTransactionData';
    let transaction = {
      signature: signature
    }
    return this.http
      .post<ResponseModel>(urlValue, transaction)
      .map(response => { return response; });
  }
  voidReturnTransaction(transaction: TransactionModel) {
    (transaction);
    const urlValue = this.url + '/VoidReturnTransaction';
    return this.http.post<ResponseModel>(urlValue, transaction).map(response => {
      return response;
    });
  }
}
