import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { TransactionModel } from "../../../models/transaction/transaction.model";
import { PaymentModel } from "../../../models/payment/payment.model";
import { ConstantMessages } from "../../../models/constants/constant-message";
import { TranslateService } from "@ngx-translate/core";


@Injectable({
  providedIn: "root",
})
export class CustomerTransactionsService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession,
    private translateService: TranslateService
  ) {
    this.url = baseUrl + "CustomerTransactions";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getTransactionsList(filter: any) {
    const urlValue = this.url + '/GetTransactionsList';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }
  voidTransaction(transaction: TransactionModel) {
    (transaction);
    const urlValue = this.url + '/VoidTransaction';
    return this.http.post<ResponseModel>(urlValue, transaction).map(response => {
      return response;
    });
  }
  voidPayments(selectedPayments: PaymentModel[]) {
    (selectedPayments);
    const urlValue = this.url + '/VoidPayments';
    return this.http.post<ResponseModel>(urlValue, selectedPayments).map(response => {
      return response;
    });
  }
  voidExchange(transaction: TransactionModel) {
    (transaction);
    const urlValue = this.url + '/VoidExchange';
    return this.http.post<ResponseModel>(urlValue, transaction).map(response => {
      return response;
    });
  }
  getTransactionData(signature: string) {
    const urlValue = this.url + '/GetTransactionData';
    let transactionData = {
      signature: signature
    }
    return this.http
      .post<ResponseModel>(urlValue, transactionData)
      .map(response => { return response; });
  }
  getPaymentTransactions(signature: string) {
    const urlValue = this.url + '/GetPaymentTransactions';
    let paymentTransaction = {
      signature: signature
    }
    return this.http
      .post<ResponseModel>(urlValue, paymentTransaction)
      .map(response => { return response; });
  }
  ShowReport(transaction: any, isShowHide: boolean) {
    const urlValue = this.url + "/ShowReport";
    if (isShowHide) {
      this.coreSession.ModalLoading.Show();
    }
    this.http.post(urlValue, transaction, { responseType: "blob" }).map(res => {
      var blob = new Blob([res], { type: "application/pdf" });
      return blob;
    }).subscribe(
      success => {
        const fileURL = URL.createObjectURL(success);
        window.open(fileURL, "_blank");
        if (isShowHide) {
          this.coreSession.ModalLoading.Hide();
        }
      },
      err => {
        if (err.status != '404') {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.Desc_There_Is_No_Template_Assigned_For_This_Customer));
        }
        if (isShowHide) {
          this.coreSession.ModalLoading.Hide();
        }
      }
    );
  }


}
