import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { map } from "rxjs/operators";
import { PaymentModel } from "../../../models/payment/payment.model";

@Injectable({
  providedIn: "root",
})
export class DownPaymentService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "DownPayment";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getDownPaymentsList(filter: any) {
    const urlValue = this.url + '/GetDownPaymentList';
    return this.http.post<ResponseModel>(urlValue, JSON.stringify(filter), this.httpOptions).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }
  saveDownPayments(selectedPayments: PaymentModel[]) {
    const urlValue: string = this.url + '/InsertDownPayments';
    (urlValue);
    return this.http.post(urlValue, selectedPayments).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  voidDownPayments(selectedPayment: PaymentModel) {
    const urlValue = this.url + '/VoidDownPayments';
    return this.http.post<ResponseModel>(urlValue, selectedPayment).map(response => {
      return response;
    });
  }


}
