import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { TransactionModel } from "../../../models/transaction/transaction.model";

@Injectable({
  providedIn: "root",
})
export class InvoiceService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "Invoice";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getCustomerTransactions(filter: any) {
    const urlValue = this.url + '/GetTransactions';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }
  getTransactionData(signature: string) {
    const urlValue = this.url + '/GetTransactionData';
    let transaction = {
      signature: signature
    }
    return this.http
      .post<ResponseModel>(urlValue, transaction)
      .map(response => { return response; });
  }

  voidTransaction(transaction: TransactionModel) {
    (transaction);
    const urlValue = this.url + '/VoidTransaction';
    return this.http.post<ResponseModel>(urlValue, transaction).map(response => {
      return response;
    });
  }

  SaveTransaction(transaction: TransactionModel) {
    const urlValue: string = this.url + '/InsertTransaction';
    return this.http.post<ResponseModel>(urlValue, transaction).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      })
  }
  getVmTransactionsForSelectedCustomers(filter: any) {
    const urlValue = this.url + '/GetVMTransactionsForSelectedCustomers';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }
  getVmTransactionDetails(filter: any) {
    const urlValue = this.url + '/GetVMTransactionsDetails';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }
}
