import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { TransactionModel } from "../../../models/transaction/transaction.model";

@Injectable({
  providedIn: "root",
})
export class TestInvoiceService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "TestInvoice";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getTestCustomerTransactions(filter: any) {
    const urlValue = this.url + '/GetTestTransactions';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }
  getTestTransactionData(signature: string) {
    const urlValue = this.url + '/GetTestTransactionData';
    let transaction = {
      signature: signature
    }
    return this.http
      .post<ResponseModel>(urlValue, transaction)
      .map(response => { return response; });
  }

  voidTestTransaction(transaction: TransactionModel) {
    (transaction);
    const urlValue = this.url + '/VoidTestTransaction';
    return this.http.post<ResponseModel>(urlValue, transaction).map(response => {
      return response;
    });
  }

  SaveTestTransaction(transaction: TransactionModel) {
    const urlValue: string = this.url + '/InsertTestTransaction';
    return this.http.post<ResponseModel>(urlValue, transaction).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      })
  }
}
