import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { map } from "rxjs/operators";
import { SavePaymentModel } from "../../../models/payment/savePaymentModel";

@Injectable({
  providedIn: "root",
})
export class PayInvoiceService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "PayInvoice/";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getUnpaidTransactions(filter: any) {
    const urlValue = this.url + 'GetUnpaidTransactions';
    return this.http.post<ResponseModel>(urlValue, filter)
      .map(response => {
        return response;
      });
  }

  savePayments(savePaymentModel: SavePaymentModel) {
    const urlValue: string = this.url + 'CollectPayments';
    return this.http.post(urlValue, JSON.stringify(savePaymentModel), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }

}
