import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { map } from "rxjs/operators";

@Injectable({
  providedIn: "root",
})
export class PostPDCService {

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "PostPDC/";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getPDCSharedTable(filter:any) {
    const urlValue = this.url + 'GetPDCSharedTable';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  } 

  postPDC(chequeList: any[]) {
    const urlValue = this.url + 'PostPaymentPDC';
    return this.http.post<ResponseModel>(urlValue, chequeList).map(response => {
      return response;
    });
  }

}
