import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject, Observable } from "rxjs";
import { CustomerModel } from "../../../models/customer/customer.model";
import { CustomerGroupModel } from "../../../models/customer/customer.group.model";
import { PaymentTermModel } from "../../../models/customer/payment-term.model";
import {
  CustomerClassModel,
  CustomerSubClassModel,
} from "../../../models/customer/customer-class.model";
import { ResponseModel } from "../../../models/api-models/api-models";
import {
  CustomerOutletModel,
  CustomerOutletContactModel,
} from "../../../models/customer/outlet.model";
import { GeneralFilter } from "../../../models/general/generalFilter.model";
import { CoreSession } from "../../../../core/core.session";
import { CustomerMappingFilter } from "../../../models/customer/customer-mapping-filter.model";

@Injectable({
  providedIn: "root",
})
export class PriceProtectionService {
  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "PriceProtection";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getPriceProtectionList(filter: any) {
    const urlValue: string = this.url + "/GetPriceProtectionList";
    return this.http.post<ResponseModel>(urlValue, filter)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }
  getPriceProtectionDetail(RequestID: string) {
    const urlValue: string = this.url + "/GetPriceProtectionData";
    let filter: GeneralFilter = {
      requestId: RequestID,
    }
    return this.http.post<ResponseModel>(urlValue, filter).map((response) => {
      const res = new ResponseModel();
      res.data = response["data"];
      res.message = response["message"];
      res.status = response["status"];
      return res;
    });
  }

  updatePricesProtectionData(priceProtectionList: any[]) {
    const urlValue: string = this.url + "/UpdatePriceProtection";
    return this.http
      .post(urlValue, JSON.stringify(priceProtectionList), this.httpOptions)
      .map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
  }

  updateStatusForPriceProtection(request: any, statusId) {
    const urlValue: string = this.url + "/UpdateStatusForPriceProtection";
    return this.http
      .post(
        urlValue + "?statusId=" + statusId,
        JSON.stringify(request),
        this.httpOptions
      )
      .map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
  }
}
