import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { ResponseModel } from "../../../models/api-models/api-models";
import { CoreSession } from "../../../../core/core.session";

@Injectable({
  providedIn: "root",
})
export class CustomerBlockedOperationService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "CustomerBlockedOperation";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getCustomerBlokedOperationData(filter: any) {
    const urlValue: string = this.url + "/GetCustomerBlokedOperationData";
    return this.http
      .get<ResponseModel>(urlValue + "?" + "filter=" + JSON.stringify(filter))
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }

  getCustomerBlockedOperations() {
    const urlValue: string = this.url + "/GetCustomerBlockedOperations";
    return this.http.post<ResponseModel>(urlValue, "").map((response) => {
      const res = new ResponseModel();
      res.data = response["data"];
      res.message = response["message"];
      res.status = response["status"];
      return res;
    });
  }

  insertCustomerBlockedOperationList(data: any) {
    const urlValue: string = this.url + "/InsertCustomerBlockedOperationList";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        return response;
      });
  }

  updateCustomerBlokedOperation(data: any){
    const urlValue: string = this.url + "/UpdateCustomerBlokedOperation";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        return response;
      });
  }

  deleteCustomerBlokedOperation(data:any ){
    const urlValue = this.url + "/DeleteCustomerBlokedOperation";
    return this.http
      .post<any>(urlValue, JSON.stringify(data) , this.httpOptions)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }
}
