import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { ResponseModel } from "../../../models/api-models/api-models";
import { CoreSession } from "../../../../core/core.session";

@Injectable({
  providedIn: "root",
})
export class CustomerICashService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "CustomerICash";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  DeleteICashData(icashListID: number) {
    const urlValue: string =
      this.url + "/DeleteICashData?icashListID=" + icashListID;
    return this.http.get<ResponseModel>(urlValue).map((response) => {
      return response;
    });
  }

  getICashCustomers(icashFilter: string) {
    const urlValue = this.url + "/GetICashCustomers";
    return this.http
      .get<ResponseModel>(
        urlValue + "?icashFilter=" + JSON.stringify(icashFilter)
      )
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }

  getICashDataInEdit(icashListID: number) {
    const urlValue: string =
      this.url + "/getICashDataInEdit"
    //?icashListID=" + icashListID;

    return this.http.post<ResponseModel>(urlValue, JSON.stringify(icashListID), this.httpOptions).map((response) => {
      const res = new ResponseModel();
      res.data = response["data"];
      res.message = response["message"];
      res.status = response["status"];
      return res;
    });
  }

  InsertOrUpdateICashData(iCashEntryModel: any, isEditMode: boolean) {
    const urlValue = this.url + (isEditMode ? "/UpdateICashData" : "/InsertICashData");
    return this.http
      .post<ResponseModel>(urlValue, iCashEntryModel)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }
}
