import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { ResponseModel } from "../../../models/api-models/api-models";
import { CoreSession } from "../../../../core/core.session";
import { map } from "rxjs/operators";

@Injectable({
  providedIn: "root",
})
export class CustomerItemBlackListService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "CustomerItemBlackList";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getBlackListData(itemBlackListId: number) {

    const urlValue: string = this.url + "/GetBlackListData"
    //?ItemBlackListId=" + itemBlackListId;

    return this.http.post<ResponseModel>(urlValue, JSON.stringify(itemBlackListId), this.httpOptions).pipe(map(
      response => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      }));
  }

  deleteBlackList(itemBlackListId: any) {
    const urlValue = this.url + "/DeleteBlackList"
    return this.http.post<ResponseModel>(urlValue, JSON.stringify(itemBlackListId), this.httpOptions).pipe(
      map(response => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      })
    );
  }
  getItemsBlackLists(filter: any) {
    const urlValue: string = this.url + '/GetItemsBlackLists'
    //+ '/GetItemsBlackLists' + '?filter=' + JSON.stringify(filter);
    return this.http.post<ResponseModel>(urlValue, JSON.stringify(filter), this.httpOptions).pipe(map(
      response => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      }));
  }

  saveItemBlackListData(blackListData: FormData, isEditMode: boolean) {
    const urlValue = this.url + (isEditMode ? "/UpdateItemBlackListData" : "/InsertItemBlackListData");
    return this.http.post<ResponseModel>(urlValue, blackListData)
      .map(response => {
        return response;
      });
  }

}
