import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { ResponseModel } from "../../../models/api-models/api-models";
import { CoreSession } from "../../../../core/core.session";

@Injectable({
  providedIn: "root",
})
export class CustomerOrderLimitService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "CustomerOrderLimit";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getCustomerOrderLimitData(filter: any) {
    const urlValue: string = this.url + "/GetCustomerOrderLimitData";
    return this.http
      .get<ResponseModel>(urlValue + "?" + "filter=" + JSON.stringify(filter))
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }

  insertCustomerOrderLimitList(data: any) {
    const urlValue: string = this.url + "/InsertCustomerOrderLimitList";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        return response;
      });
  }

  updateCustomerOrderLimit(data: any) {
    const urlValue: string = this.url + "/UpdateCustomerOrderLimit";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        return response;
      });
  }

  deleteCustomerOrderLimit(data: any) {
    const urlValue = this.url + "/DeleteCustomerOrderLimit";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }
}
