import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";

@Injectable({
  providedIn: "root",
})
export class CustomerPointBalanceService {
  customerChanged = new Subject();

  private url = "";
  private customerId: number;
  private outletId: number;
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "CustomerPointBalance";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getAllCustomersPoints(filter: any) {
    const urlValue = this.url + "/GetAllCustomersPoints";
    return this.http
      .post<ResponseModel>(urlValue, JSON.stringify(filter), this.httpOptions)
      .map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
  }

  adjustCustomersPoints(customerPoinstObj: any) {
    const urlValue = this.url + "/AdjustCustomersPoints";
    return this.http
      .post<ResponseModel>(urlValue, customerPoinstObj)
      .map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
  }

  redeemCustomersPoints(customerPoinstObj: any) {
    const urlValue = this.url + "/RedeemCustomersPoints";
    return this.http
      .post<ResponseModel>(urlValue, customerPoinstObj)
      .map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
  }
}
