import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { ResponseModel } from "../../../models/api-models/api-models";
import { CoreSession } from "../../../../core/core.session";

@Injectable({
  providedIn: "root",
})
export class CustomerSalesRestrictionService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "CustomerSalesRestriction";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getCustomerSalesRestriction(filter) {
    const urlValue: string = this.url + '/GetCustomerSalesRestriction';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response.data;
    });
  }

  getCustomerSalesRestrictionItems(filter) {
    const urlValue: string = this.url + '/GetCustomerSalesRestrictionItems';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response.data;
    });
  }

  getSalesRestrictionAssignmentToCustomers(filter) {
    const urlValue: string = this.url + '/GetSalesRestrictionCustomers';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response.data;
    });
  }

  saveCustomerSalesRestriction(customerSalesRestriction: any, isEditMode: boolean) {
    const urlValue: string = this.url + (isEditMode ? '/UpdateCustomerSalesRestriction' : '/InsertCustomerSalesRestriction');
    return this.http.post<ResponseModel>(urlValue, customerSalesRestriction).map(response => {
      return response;
    });
  }

  deleteCustomerSalesRestriction(customerSalesRestriction) {
    const urlValue: string = this.url + '/DeleteCustomerSalesRestriction';
    return this.http.post<ResponseModel>(urlValue, customerSalesRestriction).map(response => {
      return response;
    });
  }

  getCustomerSalesRestrictionOrganizations(salesRestrictionId) {
    const urlValue: string = this.url + "/GetCustomerSalesRestrictionOrganizations";
    return this.http
      .post<ResponseModel>(urlValue, JSON.stringify(salesRestrictionId), this.httpOptions)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }

}
