import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { ResponseModel } from "../../../models/api-models/api-models";
import { CoreSession } from "../../../../core/core.session";

@Injectable({
  providedIn: "root",
})
export class CustomerTemplateService {
  customerChanged = new Subject();

  private url = "";
  private customerId: number;
  private outletId: number;
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "CustomerTemplate";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  DeleteNewCustomerTemplate(newCustomerTemplateId: any) {
    const urlValue: string = this.url + "/DeleteNewCustomerTemplate";
    return this.http
      .post<ResponseModel>(urlValue, newCustomerTemplateId)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }

  GetNewCustomerTemplates(languageId: number) {
    const urlValue: string = this.url + "/GetNewCustomerTemplates";
    return this.http
      .post<ResponseModel>(urlValue, languageId)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }

  AddEditNewCustomerTemplate(CustomerObject: any, isEditMode: boolean) {
    const urlValue: string = this.url + (isEditMode ? "/UpdateNewCustomerTemplate" : "/InsertNewCustomerTemplate");
    return this.http
      .post<ResponseModel>(urlValue, CustomerObject)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }
}
