import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Inject, Injectable } from "@angular/core";
import "rxjs/add/operator/map";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
@Injectable({
    providedIn: "root",
})
export class MustSellItemService {

    private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession
    ) {
        this.url = baseUrl + "MustSellItem";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }
    getMustSellItemsSharedTable(filter) {
        const urlValue: string = this.url + "/GetMustSellItemsSharedTable";
        return this.http.post(urlValue, filter).map((response) => {
            const result = new ResponseModel();
            result.data = response["data"];
            result.message = response["message"];
            result.status = response["status"];
            return result;
        });
    }
    saveMustSellItems(mustSellItems, isEditMode: boolean) {

        const urlValue = this.url + (isEditMode ? '/UpdateMustSellItems' : '/InsertMustSellItems');
        return this.http
            .post<ResponseModel>(urlValue, mustSellItems)
            .map(response => {
                const result = new ResponseModel();
                result.data = response["data"];
                result.message = response["message"];
                result.status = response["status"];
                return result;
            });
    }
    deletetMustSellItems(mustSellItem) {
        const urlValue: string = this.url + "/DeleteMustSellItem";
        return this.http.post(urlValue, mustSellItem).map((response) => {
            const result = new ResponseModel();
            result.data = response["data"];
            result.message = response["message"];
            result.status = response["status"];
            return result;
        });
    }
    getMustSellItemData(mustSellItemObject: any) {
        const urlValue: string = this.url + '/GetMustSellItemData';
        return this.http.post<ResponseModel>(urlValue,
            mustSellItemObject).map(
                (response) => {
                    const res = new ResponseModel();
                    res.data = response['data'];
                    res.message = response['message'];
                    res.status = response['status'];
                    return res;
                }
            );
    }
    activateDeactivateMustSellItem(mustSellItemId: any, isActivate: boolean) {
        let mustSellItem = {
            mustSellItemId: mustSellItemId,
            isActive: isActivate
        }
        const urlValue: string = this.url + '/UpdateMustSellItemActivation';
        return this.http.post<ResponseModel>(urlValue, mustSellItem).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }
}