import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Inject, Injectable } from "@angular/core";
import "rxjs/add/operator/map";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
@Injectable({
    providedIn: "root",
  })
export class MustSellItemsService{
    
  private url = ""; 
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "MustSellItems";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
    getMustSellItemsSharedTable(filter) {
        const urlValue: string = this.url + "/GetMustSellItemsSharedTable";
        return this.http.post(urlValue, filter).map((response) => {
          const result = new ResponseModel();
          result.data = response["data"];
          result.message = response["message"];
          result.status = response["status"];
          return result;
        });
      }
      saveMustSellItems(mustSellObject)
      {
        const urlValue: string = this.url + "/InsertMustSellItems";
        return this.http.post(urlValue, mustSellObject).map((response) => {
          const result = new ResponseModel();
          result.data = response["data"];
          result.message = response["message"];
          result.status = response["status"];
          return result;
        });
      }
      deletetMustSellItems(mustSellObjects)
      {
        const urlValue: string = this.url + "/DeletetMustSellItems";
        return this.http.post(urlValue, mustSellObjects).map((response) => {
          const result = new ResponseModel();
          result.data = response["data"];
          result.message = response["message"];
          result.status = response["status"];
          return result;
        });
      }
      gettMustSellItems(mustSellObjectSharedTable)
      {
        const urlValue: string = this.url + "/GettMustSellItems";
        return this.http.post(urlValue, mustSellObjectSharedTable).map((response) => {
          const result = new ResponseModel();
          result.data = response["data"];
          result.message = response["message"];
          result.status = response["status"];
          return result;
        });
      }    
}