import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Inject, Injectable } from "@angular/core";
import "rxjs/add/operator/map";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
@Injectable({
  providedIn: "root",
})
export class PayerAccountService {

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "PayerAccount";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getPayerAccountSharedTable(filter) {
    const urlValue: string = this.url + "/GetPayerAccountSharedTable";
    return this.http.post(urlValue, filter).map((response) => {
      const result = new ResponseModel();
      result.data = response["data"];
      result.message = response["message"];
      result.status = response["status"];
      return result;
    });
  }
  savePayerAccounts(payerAccounts, isEditMode: boolean) {

    const urlValue = this.url + (isEditMode ? '/UpdatePayerAccount' : '/InsertPayerAccount');
    return this.http
      .post<ResponseModel>(urlValue, payerAccounts)
      .map(response => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
  }
  deletetPayerAccount(payerAccount) {
    const urlValue: string = this.url + "/DeletePayerAccount";
    return this.http.post(urlValue, payerAccount).map((response) => {
      const result = new ResponseModel();
      result.data = response["data"];
      result.message = response["message"];
      result.status = response["status"];
      return result;
    });
  }
  getPayerAccountData(payerAccountObject: any) {
    const urlValue: string = this.url + '/GetPayerAccountData';
    return this.http.post<ResponseModel>(urlValue,
      payerAccountObject).map(
        (response) => {
          const res = new ResponseModel();
          res.data = response['data'];
          res.message = response['message'];
          res.status = response['status'];
          return res;
        }
      );
  }
}
