import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { ResponseModel } from "../../../models/api-models/api-models";
import { CoreSession } from "../../../../core/core.session";

@Injectable({
  providedIn: "root",
})
export class CustomerSurveyService {

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "CustomerSurvey";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  DeleteSurvey(surveyId: any, dcfid: any, surveyTypeId: number, linkedToPromotion: boolean) {
    let filter = {
      surveyId: surveyId,
      dcfid: dcfid,
      surveyTypeId: surveyTypeId,
      linkedToPromotion: linkedToPromotion
    };
    const urlValue: string = this.url + "/DeleteSurvey";
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }

  executeCloneSurveyProcedure(surveyId: number) {
    const urlValue: string = this.url + "/CloneSurveyProcedure";
    return this.http.post<ResponseModel>(urlValue, surveyId).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }

  UpdateCustomerSurvey(surveyObject: any) {
    const urlValue: string = this.url + "/UpdateSurvey";
    return this.http.post<ResponseModel>(urlValue, surveyObject).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }

  SaveCustomerSurvey(surveyObject: any) {
    const urlValue: string = this.url + "/InsertSurvey";
    return this.http.post<ResponseModel>(urlValue, surveyObject).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }

}
