import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { ResponseModel } from "../../../models/api-models/api-models";
import { CoreSession } from "../../../../core/core.session";

@Injectable({
  providedIn: "root",
})
export class ListOfValueService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "ListOfValue";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getLOVByID(LOVID: any) {
    const urlValue: string = this.url + "/GetLOVByID";
    return this.http.post<ResponseModel>(urlValue, LOVID)
      .map(response => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      });
  }


  getLOVs() {
    const urlValue: string = this.url + "/GetLOVs";
    return this.http.post<ResponseModel>(urlValue, "").map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }

  deleteLOV(LOVID: any) {
    const urlValue: string = this.url + "/DeleteLOV";
    return this.http.post<ResponseModel>(urlValue, LOVID)
      .map(response => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      });
  }

  saveLOV(LOVObject: any, isEditMode: boolean) {
    const urlValue: string = this.url + (isEditMode ? "/UpdateLOV" : "/InsertLOV");
    return this.http.post<ResponseModel>(urlValue, LOVObject).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }
}
