import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";

@Injectable({
  providedIn: 'root'
})
export class CollectionDiscountService {

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
    ) {
      this.url = baseUrl + "CollectionDiscount";
      this.httpOptions = {
        headers: new HttpHeaders({
          "Content-Type": "application/json",
        }),
      };
     }
     getCollectionDiscounts(filter: any) {
      const urlValue: string = this.url + '/getCollectionDiscounts';
      return this.http.post<ResponseModel>(urlValue, filter).map(
        (response) => {
          const res = new ResponseModel();
          res.data = response['data'];
          res.message = response['message'];
          res.status = response['status'];
          return res;
        }
      );
    }
    getCollectionDiscountData(collectionDiscountId) {
      const urlValue: string = this.url + '/GetCollectionDiscountData';
      return this.http.post<ResponseModel>(urlValue, collectionDiscountId).map(
        (response) => {
          const res = new ResponseModel();
          res.data = response['data'];
          res.message = response['message'];
          res.status = response['status'];
          return res;
        }
      );
    }
     saveCollectionDiscount(collectionDiscountObj : any , isEditMode: boolean) {
      const urlValue = this.url + (isEditMode ? '/UpdateCollectionDiscount' : '/InsertCollectionDiscount');
      return this.http
        .post<ResponseModel>(urlValue, collectionDiscountObj)
        .map(response => {
          const res = new ResponseModel();
          res.data = response['data'];
          res.message = response['message'];
          res.status = response['status'];
          return res;
        });
    }
    updateCollectionDiscountActiveStatus(filter) {
      const urlValue: string = this.url + '/updateCollectionDiscountActiveStatus';
      return this.http.post(urlValue, filter).map(
        (response) => {
          let result = new ResponseModel();
          result.data = response['data'];
          result.message = response['message'];
          result.status = response['status'];
          return result;
        }
      );
    }
}
