import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { TranslateService } from "@ngx-translate/core";
import { ResponseModel } from "../../../models/api-models/api-models";


@Injectable({
  providedIn: "root",
})
export class ContractedFOCService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession,
    private translateService: TranslateService
  ) {
    this.url = baseUrl + "CustomerContractedFOC";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getContractedFocList(filter: any) {
    const urlValue = this.url + '/GetContractedFocList';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }
  getContractTypes() {
    const urlValue = this.url + "/GetContractTypes";
    return this.http.post<ResponseModel>(urlValue, "")
      .map(response => {
        return response;
      });
  }
  UpdateContractedFoc(contractedFoc: any) {
    const urlValue: string = this.url + "/UpdateContractedFoc";
    return this.http.post<ResponseModel>(urlValue, contractedFoc).map((response) => {
      const res = new ResponseModel();
      res.data = response["data"];
      res.message = response["message"];
      res.status = response["status"];
      return res;
    });
  }
  InsertContractedFoc(contractedFoc: any) {
    const urlValue: string = this.url + "/InsertContractedFoc";
    return this.http.post<ResponseModel>(urlValue, contractedFoc).map((response) => {
      const res = new ResponseModel();
      res.data = response["data"];
      res.message = response["message"];
      res.status = response["status"];
      return res;
    });
  }
  getContractedFocHeader(contractId: number) {
    const urlValue: string = this.url + '/GetContractedFocHeader';
    return this.http.post<ResponseModel>(urlValue,
      contractId).map(
        (response) => {
          const res = new ResponseModel();
          res.data = response['data'];
          res.message = response['message'];
          res.status = response['status'];
          return res;
        }
      );
  }
  getContractedFocOriginalData(contractedFocObject: any) {
    const urlValue: string = this.url + '/GetContractedFocOriginalData';
    return this.http.post<ResponseModel>(urlValue,
      contractedFocObject).map(
        (response) => {
          const res = new ResponseModel();
          res.data = response['data'];
          res.message = response['message'];
          res.status = response['status'];
          return res;
        }
      );
  }
  getContractedFocOriginalAppliedLists(contractedFocObject: any) {
    const urlValue: string = this.url + '/GetContractedFocOriginalAppliedLists';
    return this.http.post<ResponseModel>(urlValue,
      contractedFocObject).map(
        (response) => {
          const res = new ResponseModel();
          res.data = response['data'];
          res.message = response['message'];
          res.status = response['status'];
          return res;
        }
      );
  }
  getContractedFocData(contractedFocObject: any) {
    const urlValue: string = this.url + '/GetContractedFocData';
    return this.http.post<ResponseModel>(urlValue,
      contractedFocObject).map(
        (response) => {
          const res = new ResponseModel();
          res.data = response['data'];
          res.message = response['message'];
          res.status = response['status'];
          return res;
        }
      );
  }
  getContractedFocAppliedLists(contractedFocObject: any) {
    const urlValue: string = this.url + '/GetContractedFocAppliedLists';
    return this.http.post<ResponseModel>(urlValue,
      contractedFocObject).map(
        (response) => {
          const res = new ResponseModel();
          res.data = response['data'];
          res.message = response['message'];
          res.status = response['status'];
          return res;
        }
      );
  }
  deleteContractedFoc(contractedFOC: any) {
    const urlValue = this.url + '/DeleteContractedFoc';
    return this.http
      .post<ResponseModel>(urlValue, contractedFOC)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }
  approveOperation(Id, currentStatusId, operationTypeId) {
    const urlValue: string = this.url + '/ApproveOperation';
    return this.http.post<ResponseModel>(urlValue, { Status: currentStatusId, OperationTypeId: operationTypeId, Id: Id, IsApprove: false, OperationCode: "" }).map(response => {
      return response;
    });
  }
}
