import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";

@Injectable({
  providedIn: 'root'
})
export class HeaderDiscountService {

  private url = "";
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "HeaderDiscount";
  } 

  getHeaderDiscounts(filter: any) {
    const urlValue: string = this.url + '/GetHeaderDiscounts';
    return this.http.post<ResponseModel>(urlValue, filter).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }

  getHeaderDiscountData(headerDiscountId) {
    const urlValue: string = this.url + '/GetHeaderDiscountData';
    return this.http.post<ResponseModel>(urlValue, headerDiscountId).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }

  saveHeaderDiscount(headerDiscountObj : any , isEditMode: boolean) {
    const urlValue = this.url + (isEditMode ? '/UpdateHeaderDiscount' : '/InsertHeaderDiscount');
    return this.http
      .post<ResponseModel>(urlValue, headerDiscountObj)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }

  getSalesMode() {
    const urlValue: string = this.url + '/GetSalesMode';
    return this.http.post<ResponseModel>(urlValue, "").map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }

  deleteHeaderDiscount(headerDiscountId: number) {
    const urlValue = this.url + '/DeleteHeaderDiscount';
    return this.http
      .post<ResponseModel>(urlValue, headerDiscountId)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }
}
