import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { map } from "rxjs/operators";

@Injectable({
    providedIn: "root",
})
export class LoyaltyProgramsService {

    private url = "";
    httpOptions;
    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        private coreSession: CoreSession
    ) {
        this.url = baseUrl + "LoyaltyPrograms";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
        };
    }

    saveLoyalty(formData: FormData, isEditMode: boolean) {
        return this.http.post(this.url + (isEditMode ? '/UpdateLoyalty' : '/InsertLoyalty'), formData).map(
            (response: Response) => {
                let res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            });
    }

    deleteLoyalty(promotion) {
        const urlValue: string = this.url + '/DeleteLoyalty';
        return this.http.post(urlValue, JSON.stringify(promotion), this.httpOptions).map(
            (response) => {
                const result = new ResponseModel();
                result.data = response['data'];
                result.message = response['message'];
                result.status = response['status'];
                return result;
            }
        );
    }

    deactivateLoyalty(promotion) {
        const urlValue: string = this.url + '/UpdateFromActivateToDeactivateLoyalty';
        return this.http.post(urlValue, promotion, this.httpOptions).map(
            (response) => {
                const result = new ResponseModel();
                result.data = response['data'];
                result.message = response['message'];
                result.status = response['status'];
                return result;
            }
        );
    }
}
