import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";

@Injectable({
  providedIn: 'root'
})

export class PromotionService {

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "Promotion";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getPromotionsListSharedTable(promotionFilter: any) {
    const urlValue: string = this.url + '/GetPromotionsListSharedTable';
    return this.http.post<ResponseModel>(urlValue, promotionFilter)
      .map(
        (response) => {
          const result = new ResponseModel();
          result.data = response['data'];
          result.message = response['message'];
          result.status = response['status'];
          return result;
        });
  }
  savePromotion(formData: FormData, isEditMode: boolean) {

    return this.http.post(this.url + (isEditMode ? '/UpdatePromotion' : '/InsertPromotion'), formData).map(
      (response: Response) => {
        let res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }
  getPromotionData(promotion) {
    const urlValue = this.url + '/GetPromotionData';
    return this.http.post<ResponseModel>(urlValue, promotion).map(response => {
      return response;
    });
  }
  isValidToEditTargetPromotion(promotionId, isRelatedToTarget) {
    const urlValue = this.url + '/IsValidToEditTargetPromotion';
    let promotion = {
      PromotionId: promotionId,
      RelatedToTarget: isRelatedToTarget
    }
    return this.http.post<ResponseModel>(urlValue, promotion).map(response => {
      return response;
    });
  }
  deactivatePromotion(promotion) {
    const urlValue: string = this.url + '/UpdateFromActivateToDeactivatePromotion';
    return this.http.post(urlValue, promotion, this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  activatePromotion(promotion) {
    const urlValue: string = this.url + '/UpdateFromDeactiveToActivatePromotion';
    return this.http.post(urlValue, promotion, this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  deletePromotion(promotion) {
    const urlValue: string = this.url + '/DeletePromotion';
    return this.http.post(urlValue, JSON.stringify(promotion), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }

  getPromotionReasonList() {
    const urlValue: string = this.url + '/GetPromotionReasonList';
    return this.http.get<ResponseModel>(urlValue).map(response => {
      return response.data;
    });
  }

  getAchievementTypesForTargetPromotions() {
    const urlValue: string = this.url + '/GetAchievementTypesForTargetPromotions';
    return this.http.get<ResponseModel>(urlValue).map(response => {
      return response.data;
    });
  }

  checkAllowEditPromotionByOrgAccess(createdBy) {
    const urlValue = this.url + '/CheckAllowEditPromotionByOrgAccess';
    return this.http.post<ResponseModel>(urlValue, createdBy).map(response => {
      return response;
    });
  }
}
