import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";

@Injectable({
  providedIn: "root",
})
export class GS1TemplateService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "GS1Template";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getAllBarcodeTemplates(filter) {
    const urlValue = this.url + '/GetAllBarcodeTemplates';
    return this.http.post(urlValue, filter).map((response) => {
      const res = new ResponseModel();
      res.data = response['data'];
      res.message = response['message'];
      res.status = response['status'];
      return res;
    });
  }
  allowToDeleteTemplates(templateId) {
    const urlValue = this.url + '/AllowToRemoveTemplates';
    return this.http.post(urlValue, templateId).map(response => {
      const res = new ResponseModel();
      res.data = response['data'];
      res.message = response['message'];
      res.status = response['status'];
      return res;
    });
  }
  saveBarcodeTemplate(template) {
    const urlValue = this.url + "/InsertBarcodeTemplate";
    return this.http.post(urlValue, template).map((response) => {
      const res = new ResponseModel();
      res.data = response['data'];
      res.message = response['message'];
      res.status = response['status'];
      return res;
    });
  }
  editBarcodeTemplate(template) {
    const urlValue = this.url + "/UpdateBarcodeTemplate";
    return this.http.post(urlValue, template).map((response) => {
      const res = new ResponseModel();
      res.data = response['data'];
      res.message = response['message'];
      res.status = response['status'];
      return res;
    });
  }
  deleteBarcodeTemplate(templateId) {
    const urlValue = this.url + '/DeleteBarcodeTemplate';
    return this.http.post(urlValue, templateId).map(response => {
      const res = new ResponseModel();
      res.data = response['data'];
      res.message = response['message'];
      res.status = response['status'];
      return res;
    });
  }
  getTemplateFields() {
    const urlValue: string = this.url + '/GetTemplateFields';
    return this.http.get<ResponseModel>(urlValue).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }
  getBarcodeTemplateData(filter) {
    const urlValue: string = this.url + '/GetBarcodeTemplateData';
    return this.http.post<ResponseModel>(urlValue, filter).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }

}
