import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../models/api-models/api-models";
import { SalesRestrictionFilters } from "../../../models/salesRestriction/sales-restriction-filter.model";
import { SalesRestrictionModel } from "../../../models/salesRestriction/sales-restriction.model";

@Injectable({
  providedIn: "root",
})
export class SalesItemRestrictionService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "SalesItemRestriction";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }

  getSaleRestrictionPacks(filter: SalesRestrictionFilters) {
    const urlValue: string = this.url + "/GetSaleRestrictionPacks";
    return this.http.post<ResponseModel>(
      urlValue, filter).map(response => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });

  }

  insertSalesRestriction(salesRestriction: SalesRestrictionModel, isEditMode: boolean) {
    const urlValue: string = this.url + (isEditMode ? '/UpdateSalesRestriction' : '/InsertSalesRestriction');
    return this.http
      .post<ResponseModel>(urlValue, salesRestriction)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }

  inactivateSalesRestriction(salesRestrictionId: any) {
    const urlValue: string = this.url + '/inactivateSalesRestriction';
    return this.http
      .post<ResponseModel>(urlValue, salesRestrictionId)
      .map(response => {
        ("inactivate Plan");
        (response);

        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }

  getPlanForEdit(salesRestrictionId: number) {
    const urlValue = this.url + "/GetPlanForEdit";
    return this.http.post<ResponseModel>(urlValue, salesRestrictionId).map(response => {
      return response;
    });
  }

  getAllAvailablePlans(planFilter: any) {
    const urlValue: string = this.url + '/GetAllPlansAvailable';
    (urlValue);
    return this.http.post(urlValue, JSON.stringify(planFilter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }

}
