import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import "rxjs/add/operator/map";
import { Subject } from "rxjs";
import { ResponseModel } from "../../models/api-models/api-models";
import { TranslateService } from "@ngx-translate/core";
import { CoreSession } from "../../../core/core.session";
import { ConstantMessages } from "../../models/constants/constant-message";

@Injectable({
  providedIn: "root",
})
export class DisplayUnitCustomerImagesService {
  customerChanged = new Subject();

  private url = "";
  httpOptions;
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession,
    private translateService: TranslateService
  ) {
    this.url = baseUrl + "DisplayUnitCustomerImage";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getDisplayUnitCustomerImagesSharedTable(filter: any) {
    const urlValue: string = this.url + '/GetDisplayUnitCustomerImagesSharedTable';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  exportReport(filter: any, isShowHide: boolean) {
    const urlValue = this.url + "/ExportReport";
    if (isShowHide) {
      this.coreSession.ModalLoading.Show();
    }
    this.http.post(urlValue, filter, { responseType: "blob" }).map(res => {
      var blob = new Blob([res], { type: "application/pdf" });
      return blob;
    }).subscribe(
      success => {
        const fileURL = URL.createObjectURL(success);
        window.open(fileURL, "_blank");
        if (isShowHide) {
          this.coreSession.ModalLoading.Hide();
        }
      },
      err => {
        if (err.status != '404') {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgNoDataFound));
        }
        if (isShowHide) {
          this.coreSession.ModalLoading.Hide();
        }
      }
    );
  }
}

