import { Injectable, Inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { ResponseModel } from '../../../shared/models/api-models/api-models';

@Injectable({
  providedIn: 'root'
})
export class CancelRouteService {
  private url = '';
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    this.url = baseUrl + 'CancelRoute';
  }

  getCancelRoute(filter: any) {
    const urlValue: string = this.url + '/GetCancelRoute';
    return this.http.post<ResponseModel>(urlValue, filter).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }
  cancelRoute(routeHistory: any) {
    const urlValue: string = this.url + "/CancelRoute";
    return this.http.post<ResponseModel>(urlValue, routeHistory).map(
      response => {
        return response;
      });
  }
}
